%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 


clearvars; clc;
%load the cross-section of call option prices (obtained by put-call parity
%using only out-of-the-money options) written on SPY with 1 month to expiry
%or 1 week to expiry
load('SPY_181019_1M.mat')
plot(strike,o_observe,'o')
grid on
xlabel('strike')
ylabel('call prices')
xline(Ft,'label','F_t','LineStyle','--');

%Set up options for RND estimation. Please see the function for available
%options and default choice
LWM_options = LWM_options_setup();

%Estimate the LWM parameters with a maximum of 5 mixtures and equal weights
weights = ones(size(o_observe));
LWM_results = LWM_RND(o_observe, strike, rf, ttm, Ft, 5, weights, LWM_options);

% Sequential test
Mchoice = 3;
M1=LWM_results.fvals(Mchoice,4);
M2=LWM_results.fvals(Mchoice,5);
estpar =  LWM_results.('M_'+string(Mchoice)+'_estpar');
[residinfo,parminfo,RNDinfo,testinfo] = LWM_RND_infer(estpar,M1,M2,o_observe,strike, rf, ttm,weights,[1 1 0.05],true);

 
 